<?php
require_once '../config/db.php';
$settings = [];
$stmt = $pdo->query('SELECT key_name, value FROM settings');
foreach ($stmt as $row) {
    $settings[$row['key_name']] = $row['value'];
}
?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>من نحن</title>
    <link rel="stylesheet" href="../public/style.css">
    <style>
        body { background: <?= $settings['bg_color'] ?? '#EEEEEE' ?>; font-family: 'Cairo', sans-serif; }
        .navbar { background: <?= $settings['main_color'] ?? '#EA9218' ?>; color: #fff; padding: 12px 0; display: flex; align-items: center; justify-content: space-between; }
        .navbar img { height: 48px; margin-right: 16px; }
        .navbar ul { list-style: none; display: flex; gap: 24px; margin: 0; padding: 0; }
        .navbar li { display: inline; }
        .navbar a { color: #fff; text-decoration: none; font-weight: bold; font-size: 18px; }
        .container { max-width: 900px; margin: 32px auto; background: #fff; border-radius: 8px; box-shadow: 0 0 10px #31384122; padding: 32px; }
        h2 { color: #EA9218; margin-bottom: 16px; text-align: center; }
        .section-title { color: #3A4750; font-size: 20px; margin-bottom: 12px; }
        .about-text { color: #313841; font-size: 17px; margin-bottom: 24px; text-align: center; }
        .team { display: flex; flex-wrap: wrap; gap: 24px; justify-content: center; margin-bottom: 32px; }
        .team-member { background: #EEEEEE; border-radius: 8px; padding: 16px; min-width: 160px; text-align: center; color: #3A4750; }
        .gallery { display: flex; flex-wrap: wrap; gap: 16px; justify-content: center; margin-bottom: 32px; }
        .gallery img { max-width: 180px; max-height: 120px; border-radius: 6px; }
        .map-section { text-align: center; margin-bottom: 32px; }
        .footer { background: <?= $settings['secondary_color'] ?? '#3A4750' ?>; color: #fff; padding: 24px 0; text-align: center; margin-top: 48px; }
        .footer img { height: 40px; margin-bottom: 8px; }
    </style>
</head>
<body>
    <!-- النافبار -->
    <nav class="navbar">
        <div>
            <img src="../assets/<?= htmlspecialchars($settings['logo'] ?? 'logo.png') ?>" alt="شعار الشركة">
        </div>
        <ul>
            <li><a href="index.php">الرئيسية</a></li>
            <li><a href="projects.php">المشاريع</a></li>
            <li><a href="about.php">من نحن</a></li>
            <li><a href="contact.php">تواصل معنا</a></li>
            <li><a href="#" onclick="alert('قريباً!');">تغيير اللغة</a></li>
        </ul>
    </nav>
    <div class="container">
        <h2>من نحن</h2>
        <div class="section-title">تعريف عن الشركة</div>
        <div class="about-text">شركة عقارية رائدة تقدم أفضل المشاريع السكنية والتجارية، وتهدف إلى تقديم حلول عقارية مبتكرة تلبي احتياجات العملاء وتحقق تطلعاتهم.</div>
        <div class="section-title">الرؤية والرسالة</div>
        <div class="about-text">رؤيتنا: أن نكون الخيار الأول في سوق العقارات.<br>رسالتنا: تقديم مشاريع عالية الجودة وخدمة عملاء متميزة.</div>
        <div class="section-title">فريق العمل</div>
        <div class="team">
            <div class="team-member">محمد القحطاني<br>المدير العام</div>
            <div class="team-member">سارة العتيبي<br>مديرة المشاريع</div>
            <div class="team-member">خالد الزهراني<br>مسؤول التسويق</div>
            <div class="team-member">نورة السبيعي<br>خدمة العملاء</div>
        </div>
        <div class="section-title">صور مقر الشركة ومشاريع سابقة</div>
        <div class="gallery">
            <img src="../assets/company1.jpg" alt="مقر الشركة">
            <img src="../assets/project1.jpg" alt="مشروع سابق">
            <img src="../assets/project2.jpg" alt="مشروع سابق">
        </div>
        <div class="section-title">خريطة موقع الشركة</div>
        <div class="map-section">
            <?php if (!empty($settings['address'])): ?>
                <iframe src="https://www.google.com/maps?q=<?= urlencode($settings['address']) ?>&output=embed" width="100%" height="300" style="border:0;border-radius:8px;" allowfullscreen="" loading="lazy"></iframe>
            <?php endif; ?>
        </div>
    </div>
    <!-- الفوتر -->
    <footer class="footer">
        <?php if (!empty($settings['logo'])): ?>
            <img src="../assets/<?= htmlspecialchars($settings['logo']) ?>" alt="شعار الشركة">
        <?php endif; ?>
        <div><?= htmlspecialchars($settings['company_name'] ?? 'شركتنا العقارية') ?></div>
        <div>جميع الحقوق محفوظة &copy; <?= date('Y') ?></div>
    </footer>
</body>
</html>
